/*
 * Decompiled with CFR 0.152.
 */
package com.yurtmod.block;

import com.yurtmod.block.BlockUnbreakable;
import com.yurtmod.block.Categories;
import com.yurtmod.block.TileEntityTentDoor;
import com.yurtmod.dimension.TentDimension;
import com.yurtmod.item.ItemMallet;
import com.yurtmod.structure.StructureBase;
import com.yurtmod.structure.StructureType;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTentDoor
extends BlockUnbreakable
implements ITileEntityProvider,
Categories.ITepeeBlock,
Categories.IYurtBlock,
Categories.IBedouinBlock {
    public static final PropertyEnum<EnumFacing.Axis> AXIS = PropertyEnum.func_177706_a((String)"axis", EnumFacing.Axis.class, (Enum[])new EnumFacing.Axis[]{EnumFacing.Axis.X, EnumFacing.Axis.Z});
    public static final int DECONSTRUCT_DAMAGE = 5;
    private static final double aabbDis = 0.375;
    public static final AxisAlignedBB AABB_X = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.0, 1.0);
    public static final AxisAlignedBB AABB_Z = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.0, 0.625);
    public final boolean isCube;

    public BlockTentDoor(boolean isFull) {
        super(Material.field_151575_d);
        this.isCube = isFull;
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a(AXIS, (Comparable)EnumFacing.Axis.X));
        this.func_149647_a(null);
    }

    public BlockTentDoor() {
        this(false);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        Material m1 = world.func_180495_p(pos).func_185904_a();
        Material m2 = world.func_180495_p(pos.func_177981_b(1)).func_185904_a();
        return !(m1 != Material.field_151579_a && m1 != Material.field_151586_h || m2 != Material.field_151579_a && m2 != Material.field_151586_h);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) return false;
        BlockPos base = ((BlockDoor.EnumDoorHalf)state.func_177229_b((IProperty)BlockDoor.field_176523_O)).equals((Object)BlockDoor.EnumDoorHalf.LOWER) ? pos : pos.func_177979_c(1);
        TileEntity te = worldIn.func_175625_s(base);
        if (te != null && te instanceof TileEntityTentDoor) {
            EnumFacing dir;
            TileEntityTentDoor teyd = (TileEntityTentDoor)te;
            StructureType type = teyd.getStructureType();
            StructureBase struct = type.getNewStructure();
            EnumFacing enumFacing = dir = TentDimension.isTentDimension(worldIn) ? TentDimension.STRUCTURE_DIR : struct.getValidFacing(worldIn, base);
            if (dir == null) {
                return false;
            }
            if (worldIn.field_72995_K || player.func_184586_b(hand) == null || !(player.func_184586_b(hand).func_77973_b() instanceof ItemMallet) || TentDimension.isTentDimension(worldIn)) return ((TileEntityTentDoor)te).onPlayerActivate(player);
            ItemStack toDrop = type.getDropStack(teyd.getOffsetX(), teyd.getOffsetZ());
            if (toDrop == null) return false;
            EntityItem dropItem = new EntityItem(worldIn, player.field_70165_t, player.field_70163_u, player.field_70161_v, toDrop);
            dropItem.func_174867_a(0);
            worldIn.func_72838_d((Entity)dropItem);
            struct.remove(worldIn, base, dir, StructureType.Size.SMALL);
            player.func_184586_b(hand).func_77972_a(5, (EntityLivingBase)player);
            return true;
        }
        System.out.println("[BlockTentDoor] Error! Failed to retrieve TileEntityTentDoor at " + pos);
        return false;
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        this.func_180634_a(worldIn, pos, worldIn.func_180495_p(pos), entityIn);
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        TileEntity te;
        if (!worldIn.field_72995_K && worldIn.func_180495_p(pos).func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER && (te = worldIn.func_175625_s(pos)) != null && te instanceof TileEntityTentDoor) {
            EnumFacing dir;
            TileEntityTentDoor teDoor = (TileEntityTentDoor)te;
            StructureType type = teDoor.getStructureType();
            StructureBase struct = type.getNewStructure();
            EnumFacing enumFacing = dir = TentDimension.isTentDimension(worldIn) ? TentDimension.STRUCTURE_DIR : struct.getValidFacing(worldIn, pos);
            if (dir != null) {
                teDoor.onEntityCollide(entityIn, dir);
            }
        }
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (((BlockDoor.EnumDoorHalf)state.func_177229_b((IProperty)BlockDoor.field_176523_O)).equals((Object)BlockDoor.EnumDoorHalf.LOWER)) {
            worldIn.func_180501_a(pos.func_177984_a(), this.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a(AXIS, state.func_177229_b(AXIS)), 3);
        }
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (this.isCube) {
            return field_185505_j;
        }
        EnumFacing.Axis axis = (EnumFacing.Axis)state.func_177229_b(AXIS);
        if (axis.equals((Object)EnumFacing.Axis.X)) {
            return AABB_X;
        }
        return AABB_Z;
    }

    public boolean func_149662_c(IBlockState state) {
        return this.isCube;
    }

    public boolean func_149686_d(IBlockState state) {
        return this.isCube;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return this.isCube ? BlockRenderLayer.SOLID : BlockRenderLayer.CUTOUT;
    }

    public void func_176206_d(World worldIn, BlockPos pos, IBlockState state) {
        if (state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER) {
            worldIn.func_175698_g(pos.func_177981_b(1));
        } else {
            worldIn.func_175698_g(pos.func_177979_c(1));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockDoor.field_176523_O, AXIS});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)(meta % 2 == 0 ? BlockDoor.EnumDoorHalf.LOWER : BlockDoor.EnumDoorHalf.UPPER)).func_177226_a(AXIS, (Comparable)(meta > 1 ? EnumFacing.Axis.Z : EnumFacing.Axis.X));
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        if (((BlockDoor.EnumDoorHalf)state.func_177229_b((IProperty)BlockDoor.field_176523_O)).equals((Object)BlockDoor.EnumDoorHalf.UPPER)) {
            ++meta;
        }
        if (((EnumFacing.Axis)state.func_177229_b(AXIS)).equals((Object)EnumFacing.Axis.Z)) {
            meta += 2;
        }
        return meta;
    }

    public boolean hasTileEntity(IBlockState state) {
        return state.func_177229_b((IProperty)BlockDoor.field_176523_O) == BlockDoor.EnumDoorHalf.LOWER;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        TileEntityTentDoor ret = new TileEntityTentDoor();
        ret.func_145834_a(worldIn);
        return ret;
    }
}

